#!/bin/csh

if ( $1 != "" ) then
  set compiler_switch = $1
else 
  set compiler_switch = "gnu"
endif

switch ( $compiler_switch )
    case 'INTEL'
    case 'Intel'
    case 'intel'
    setenv INTEL YES
    echo 'Using Intel compilers, icc, icpc, ifort'
    breaksw

default:
    echo 'Using default GNU compilers, gcc, g++, gfortran'
endsw

set perl = `/usr/bin/env perl -v |& grep "This is perl"`

if ( "$perl" == "" ) then
  set altperl = `/bin/env perl -v |& grep "This is perl"`
  if ( "$altperl" == "") then
    echo "*** Looks like perl is not available." 
    echo "  Please install perl version 5.004 or newer and include"
    echo "  its location in the search path"
    exit 1
  else
    echo "replacing /usr/bin/env with /bin/env in perl utilities"
    foreach np ( perl/*.pl )
      sed -e "s/\/usr\/bin\/env/\/bin\/env/" $np > $$.tmp
      cp $$.tmp $np
    end
    rm $$.tmp
  endif
endif

echo "Compiling source files"

set pwd = `pwd`

mkdir bin >& /dev/null

cd src; make all; cd ..

echo "Done"
echo ""
echo "Do not forget to set MMTSBDIR to $pwd and"
echo 'add $MMTSBDIR/perl and $MMSTBDIR/bin to your path.'
echo ""
echo "If you have CHARMM available, please also set CHARMMEXEC"
echo "and CHARMMDATA to the location of the executable and"
echo "CHARMM data directory" 
echo ""
echo "Please send comments/questions to mmtsb@mmtsb.org"

